#!/bin/sh
# the next line restarts using tclsh \
    exec tclsh "$0" "$@"

# This is the main file that runs everything else.

# $Id: WeSoLo.tcl,v 1.2 2003/09/09 23:54:10 davidw Exp $



package require Tk
package require BWidget

if { [lsearch $auto_path .] < 0 } {
    lappend auto_path .
}

package require logcontrol
package require gridinfo
package require preferences

source frame.tcl

namespace eval gui {
    namespace import ::gridinfo::*
    if { [tk windowingsystem] == "x11" } {
	option add *borderWidth 1 widgetDefault
	option add *activeBorderWidth 1 widgetDefault
	option add *selectBorderWidth 1 widgetDefault
	option add *font -adobe-helvetica-medium-r-normal-*-12-*-*-*-*-*-*
    }

    set rcfile [file join ~ .wesolorc]
    set lastlog ""
}


# gui::loadfile --
#
#	Displays the file open dialog, and starts the tail/replay
#	running.
#
# Arguments:
#	mode - tailf or replay.
#
# Side Effects:
#	Sets up a lastlog variable that is used to save the last used
#	log name on exit.
#
# Results:
#	None.

proc gui::loadfile {mode} {
    variable opmode $mode
    variable pause
    variable g
    variable lastlog

    set types {
	{"Log" .log}
	{"All files" *}
    }

    if { $lastlog == "" } {
	set lastlog [tk_getOpenFile -filetypes $types]
    } else {
	set lastlog [tk_getOpenFile -filetypes $types -initialdir [file dirname $lastlog]]
    }
    if { $lastlog == "" } {
	return
    }
    logcontrol::init $lastlog gui::newinfo gui::timeout $mode
    $g.ctl.pause configure -state normal
    $g.ctl.pause configure -text "Pause"
    Circle configure -foreground green
}

proc gui::help {} {
    catch {
	destroy .help
    }
    toplevel .help
    set h [text .help.h  -yscrollcommand ".help.sc set"]
    set sc [scrollbar .help.sc -command ".help.h yview"]
    set b [button .help.b -text Dismiss -command [list wm withdraw .help]]
    pack $b -fill x -side bottom
    pack $h -fill both -side left -expand 1
    pack $sc -side right  -expand 1 -fill y
    $h tag config title -justify center -font -adobe-helvetica-bold-r-normal-*-20-*-*-*-*-*-*
    $h tag config center -justify center
    $h tag config bold -font -adobe-helvetica-bold-r-normal-*-12-*-*-*-*-*-*
    $h tag config right -font -adobe-helvetica-normal-r-normal-*-12-*-*-*-*-*-* -wrap word
    set commands {
	{"Open Log File for Tail" "Runs the equivalent of 'tail -f' on a logfile being written to by the web server."}
	{"Open Log File for Replay" "'Replay's a log file, showing you the hits as they take place."}
    }
    set preferences {
	{"Playback Delay" "The amount of time to pause between lines in a log file being played back."}
	{"Tail Delay" "Amount of time to wait before checking for new input from file being tailed."}
	{"Session Timeout" "A session is determined by a number of requests arriving from a particular IP.  It is considered to have 'timed out' if no new requests have arrived in this time period."}
	{"Browser command" "Execute this command when the user clicks on a URL.  %s is replaced by the URL."}
    }

    $h insert 0.0 "WeSeLo Help\n\n" title
    foreach cmddesc $commands {
	$h insert end "\n[lindex $cmddesc 0] -	" bold [lindex $cmddesc 1] right
    }
    $h insert end "\n\nConfiguration Options:\n\n" bold
    foreach prefdesc $preferences {
	$h insert end "\n[lindex $prefdesc 0] -	" bold [lindex $prefdesc 1] right
    }

    $h config -state disabled

}


proc gui::about {} {
    variable g
    catch { destroy $g.about }
    set a [toplevel $g.about -class dialog]
    wm title $a "About HTMLAlbum"
    button $a.b -text Dismiss -command [list wm withdraw $a]

    text $a.text -height 9 -bd 1 -width 60
    pack $a.b -fill x -side bottom
    pack $a.text -fill both -side left -expand 1
    $a.text tag config center -justify center
    $a.text tag config title -justify center -font {Courier -18 bold}
    $a.text insert 1.0 "About WeSeLo" title \
          "\n\nCopyright (C) 2000-2003 David N. Welton <davidw@dedasys.com>" \
          center \
          "\n\nAvailable from http://www.dedasys.com/freesoftware/" center
    $a.text config -state disabled
}

proc gui::init {} {
    variable g
    variable mainframe
    variable rcfile
    variable lastlog

    wm withdraw .
    set g [toplevel .gui]
    wm title .gui "Log Rings"
    menu $g.mbar -borderwidth 1
    $g config -menu $g.mbar

    $g.mbar add cascade -label "File" -underline 0 \
	-menu [menu $g.mbar.file -tearoff 0]

    $g.mbar add command -label "Preferences" -underline 0 -command gui::prefs

    $g.mbar add cascade -label "Help" -underline 0 \
	-menu [menu $g.mbar.help -tearoff 0]

    set m $g.mbar.file

    $m add command -label "Open Log File" -underline 0 \
	-command [list gui::loadfile tailf]
    $m add command -label "Open Log File for Replay" -underline 0 \
	-command [list gui::loadfile playback]
    $m add command -label "Exit" -underline 0 -command gui::quit

    set m $g.mbar.help
    $m add command -label "Help" -underline 0 -command gui::help
    $m add command -label "About" -underline 0 -command gui::about

    frame $g.ctl
    grid $g.ctl -sticky nw
    grid columnconfigure $g [column $g.ctl] -weight 1

    image create bitmap Circle -file circle.bmp -foreground green
    button $g.ctl.pause -compound left -image Circle -text "Pause" \
	-command gui::pause -state disabled
    label $g.ctl.time -text [clock format [clock seconds]]

    grid $g.ctl.pause $g.ctl.time -sticky nws

    scrollbar $g.yscr -command [list $g.mainframe yview]
    scrollbar $g.xscr  -orient horiz -command [list $g.mainframe xview]
    ScrollableFrame $g.mainframe -yscrollcommand [list $g.yscr set] \
	-xscrollcommand [list $g.xscr set]
    set mainframe [$g.mainframe getframe]
    grid $g.mainframe $g.yscr -sticky news
    grid rowconfigure $g [row $g.mainframe] -weight 1

    $mainframe configure -borderwidth 1 -bg black
    #   bind $g <Destroy> gui::quit
    wm protocol $g WM_DELETE_WINDOW gui::quit
    catch { source $rcfile }
}

proc gui::pause {} {
    variable g

    if { [logcontrol::pause] == 0 } {
	$g.ctl.pause configure -text "Unpause"
	Circle configure -foreground red
	logcontrol::pause 1
    } else {
	$g.ctl.pause configure -text "Pause"
	Circle configure -foreground green
	logcontrol::pause 0
    }
}

proc gui::newframe {ip ua} {
    variable g
    variable ip2frames
    variable frames2ip
    variable mainframe
    set ipf [ipframe::create $mainframe $ip $ua]

    set ip2frames($ip) $ipf
    set frames2ip($ipf) $ip

    grid $ipf -sticky news
    grid columnconfigure $mainframe [column $ipf] -weight 1
    grid rowconfigure $mainframe [row $ipf] -weight 1
}

proc gui::timeout {ip} {
    variable ip2frames
    variable frames2ip

    set f $ip2frames($ip)
    destroy $f
    unset frames2ip($f)
    unset ip2frames($ip)
    return 1
}

proc gui::newinfo {ip time url ref ua} {
    variable g
    variable ip2frames

    $g.ctl.time configure -text [clock format $time]
    if { [info exists ip2frames($ip)] } {
	ipframe::pathappend $ip2frames($ip) $url
    } else {
	newframe $ip $ua
	ipframe::pathappend $ip2frames($ip) $url
	ipframe::setref $ip2frames($ip) $ref
    }
}

proc gui::prefs {} {
    variable prefs
    prefs::create [logcontrol::getprefs] logcontrol::setprefs
    prefs::addwidget "Playback Delay (milliseconds)" {
	spinbox -from 0 -to 10000 -increment 10 -validate key -vcmd {string is integer %P}
    } playback,playbackdelay
    prefs::addwidget "Tail Delay (milliseconds)" {
	spinbox -from 0 -to 10000 -increment 10 -validate key -vcmd {string is integer %P}
    } tailf,delay
    prefs::addwidget "Session Timout (seconds)" {
	spinbox -from 0 -to 600 -increment 1 -validate key -vcmd {string is integer %P}
    } timeout
    prefs::addwidget "Browser command" {
	entry
    } browser
}

proc gui::quit {} {
    variable g
    variable rcfile
    variable lastlog

    set fl [open $rcfile w]
    puts $fl "wm geometry $g [winfo geometry $g]"
    puts $fl "set lastlog $lastlog"
    close $fl
    exit 0
}

gui::init