# $Id: frame.tcl,v 1.1.1.1 2003/09/09 23:36:29 davidw Exp $

package require Tk

if { [lsearch $auto_path .] < 0 } {
    lappend auto_path .
}

package require gridinfo

namespace eval ipframe {
    namespace import ::gridinfo::*
    set Id 0
}

# ipframe::create --
#
#	Create a frame with space for the hostname, useragent referer,
#	and the list of url's requested by the remote client.
#
# Arguments:
#	toplevel - the toplevel that contains this frame.
#	ip - hostname of the remote client.
#	ua - user agent of the remote client.
#
# Side Effects:
#	Creates frame and elements within it.
#
# Results:
#	Returns the name of the frame.

proc ipframe::create {toplevel ip ua} {
    variable Id
    set f $toplevel.f$Id

    frame $f -borderwidth 1 -relief solid
    label $f.ip -bg \#aaaaff -text $ip
    label $f.ua -text $ua

    text $f.ref -bg \#aaffaa -height 1 -state disabled -relief flat
    text $f.pathlist -bg \#ffffaa -height 3 -state disabled -relief flat
    bind $f.pathlist <Any-Enter> [list after 100 [list ipframe::showpath %W]]

    grid $f.ip $f.pathlist -sticky news
    grid $f.ua -sticky news
    grid $f.ref -sticky news
    grid configure $f.pathlist -rowspan 3

    grid columnconfigure $f [column $f.ip] -weight 1
    grid columnconfigure $f [column $f.pathlist] -weight 1
    grid rowconfigure $f [row $f.ref] -weight 1

    incr Id
    return $f
}

proc ipframe::gotourl {url} {
    upvar [logcontrol::getprefs] localprefs
    eval exec [format $localprefs(browser) $url]
}

proc ipframe::setref {id ref} {
    $id.ref configure -state normal
    $id.ref delete 0.0 end
    $id.ref tag configure URL -underline 1 -foreground blue
    $id.ref tag bind URL <Enter> [list $id.ref config -cursor hand2]
    $id.ref tag bind URL <Leave> [list $id.ref config -cursor left_ptr]
    $id.ref tag bind URL <1> [list ipframe::gotourl $ref]

    $id.ref insert end $ref URL
    $id.ref configure -state disabled

    set strlen  [string length $ref]
    set refw [$id.ref cget -width]
    set refh [$id.ref cget -height]
    if { $strlen > $refw * $refh } {
	$id.ref configure -height [expr {($strlen / $refw) + 1}]
    }
}

proc ipframe::showpath {w} {
    if { [eval winfo containing  [winfo pointerxy .]] != $w } {return}
    set top $w.balloon
    catch {destroy $top}
    toplevel $top -bd 1 -bg black
    bind $top <Any-Leave> [list destroy $top]
    wm overrideredirect $top 1
    if {$::tcl_platform(platform) == "macintosh"} {
	unsupported1 style $top floating sideTitlebar
    }
    set t [text $top.txt -bg lightyellow -relief flat \
	       -width [$w cget -width]]
    set str [$w get 0.0 end]
    set nlc [llength [split $str \n]]
#    $t configure -height [$w cget -height]
    $t configure -height $nlc
    $t insert end [$w get 0.0 end-1char]
    $t configure -state disabled

    grid $t -sticky news
    grid columnconfigure $top 0 -weight 1
    grid rowconfigure $top 0 -weight 1
    set wmx [winfo rootx $w]
    set wmy [winfo rooty $w]
    wm geometry $top +$wmx+$wmy
    update
    set wh [winfo height $w]
    set th [winfo height $t]
    set height [expr {$wh > $th ? $wh : $th }]

    wm geometry $top [winfo width $w]x$height+$wmx+$wmy

    raise $top
}

proc ipframe::pathappend {id path} {
    variable FirstAppend 1
    $id.pathlist configure -state normal
    $id.pathlist insert end "\n$path"
    $id.pathlist configure -state disabled
    $id.pathlist see end
    if { [info commands $id.pathlist.balloon.txt] != "" } {
	$id.pathlist.balloon.txt configure -state normal
	$id.pathlist.balloon.txt insert end "\n$path"
	$id.pathlist.balloon.txt configure -state disabled
	$id.pathlist.balloon.txt see end
	set nlc [llength [split [$id.pathlist.balloon.txt get 0.0 end] \n]]
	$id.pathlist.balloon.txt configure -height $nlc

	set wmx [winfo rootx $id.pathlist]
	set wmy [winfo rooty $id.pathlist]
#	set wmy [expr {[winfo rooty $id.pathlist] - ([winfo reqheight $id.pathlist.balloon.txt] / 2)}]

	wm geometry $id.pathlist.balloon ""
#	wm geometry $id.pathlist.balloon +$wmx+$wmy
    }
}
