# $Id: logcontrol.tcl,v 1.2 2003/09/09 23:54:10 davidw Exp $

# This file handles all of the logic and program flow.

if { [lsearch $auto_path .] < 0 } {
    lappend auto_path .
}

package require tailf
package require playback
package require lookup

package provide logcontrol 0.1

namespace eval logcontrol {
    variable iptimeouts
    variable ipurls
    variable iprefs
    set paused 0
    array set iprefs {}
    array set prefs {}
    set prefs(timeout) 600
    set prefs(browser) "mozilla -remote openURL(%s)"
    set modes {tailf playback}
    set mode tailf
}


# logcontrol::parseline_apache_combined --
#
#	Parse Apache's 'combined' log file format.
#
# Arguments:
#	line - line to parse.
#
# Side Effects:
#	Fills in the iptimeouts, ipurls and iprefs arrays.
#
# Results:
#	None.

proc logcontrol::parseline_apache_combined {line} {
    variable iptimeouts
    variable ipurls
    variable iprefs

    if { [catch {
	set ip [lookup::lookup [lindex $line 0]]

    set time [string trimleft [lindex $line 3] \[]
    regexp {(\d\d/.../\d\d\d\d):(\d\d:\d\d:\d\d)} $time match date time
    set date [string map {/ " "} $date]
    set time [clock scan "$time $date"]
    set url [lindex [lindex $line 5] 1]
    set ua [lindex $line 9]

    set iptimeouts($ip) $time
    lappend ipurls($ip) $url

    # Usually the referer that interests us is the first one.
    set ref [lindex $line 8]
    if { $ref != "-" && ! [info exists iprefs($ip)] } {
	set iprefs($ip) $ref
    } else {
	set ref ""
    }

    callbacks $ip $time $url $ref $ua
    } err] } {
	puts stderr "Parse error: $line $err"
    }
}


# logcontrol::callbacks --
#
#	Runs the callback to update the GUI, whatever it may be.
#
# Arguments:
#	ip, time, url, ref, ua - information about the request.
#
# Side Effects:
#	Runs the timeout check and unsets the necessary variables if
#	the session has timed out.
#
# Results:
#	None.

proc logcontrol::callbacks {ip time url ref ua} {
    variable guiupdateproc
    variable timeoutproc
    variable iptimeouts
    variable prefs

    $guiupdateproc $ip $time $url $ref $ua
    foreach {i t} [array get iptimeouts] {
	if { $time > $t + $prefs(timeout) } {
	    if { [$timeoutproc $i] == 1 } {
		catch { unset iptimeouts($i) }
		catch { unset ipurls($i) }
		catch { unset iprefs($i) }
	    }
	}
    }
}


proc logcontrol::putsupdate {ip time url ref} {
    variable iptimeouts
    variable ipurls
    variable iprefs

    puts $ip
    parray iptimeouts
    parray ipurls
    parray iprefs
}

proc logcontrol::pause {{bool ""}} {
    variable paused
    variable mode
    if { $bool != "" } {
	set paused $bool
	${mode}::pause $bool
    } else {
	return $paused
    }
}

proc logcontrol::setprefs {newarr} {
    variable mode
    variable modes
    variable prefs

    upvar $newarr localarr

    foreach md $modes {
	foreach {key val} [array get localarr $md,*] {
	    lappend seenkeys $key
	    set key [string map [list "$md," ""] $key]
	    set ${md}::prefs($key) $val
	}
    }

    foreach {key val} [array get localarr] {
	set prefs($key) $val
    }
}

proc logcontrol::getprefs {} {
    variable modes
    variable prefs
    foreach md $modes {
	foreach {key val} [array get ${md}::prefs] {
	    set prefs($md,$key) $val
	}
    }
    return logcontrol::prefs
}

proc logcontrol::mode {} {
    variable mode
    return $mode
}

proc logcontrol::init {fn updatecallback timeoutcallback md} {
    variable guiupdateproc
    variable timeoutproc
    variable mode $md

    set guiupdateproc $updatecallback
    set timeoutproc $timeoutcallback
    if { $mode == "tailf" } {
	tailf::tailf $fn logcontrol::parseline_apache_combined
    } else {
	playback::playback $fn logcontrol::parseline_apache_combined
    }
}
