# $Id: lookup.tcl,v 1.1.1.1 2003/09/09 23:36:29 davidw Exp $

package require Tclx

package provide lookup 0.1

# This should probably use threads and callbacks of some kind in order
# to do this asynchronously for those who don't have fast connections.

namespace eval lookup {
    set delay 600000
    set timeout [expr {$delay * 2}]
    array set cache {}
    after $delay lookup::cachegc
}

proc lookup::lookup {addr} {
    variable cache

    if { [info exists cache($addr)] } {
	return [lindex $cache($addr) 0]
    }

    if { [catch {
	set hn [host_info official_name $addr]
    } err] } {
	set hn $addr
    }
    set cache($addr) [list $hn [clock seconds]]
    return $hn
}

proc lookup::cachegc {} {
    variable cache
    variable delay

    set time [clock seconds]
    foreach {key val} [array get cache] {
	if { $time > [lindex $val 1] + 10 } {
	    unset cache($key)
	}
    }
    after $delay lookup::cachegc
}

