# $Id: playback.tcl,v 1.1.1.1 2003/09/09 23:36:29 davidw Exp $

package provide playback 0.1

namespace eval playback {
    set stop 0
    set paused 0
    array set prefs {}
    set prefs(playbackdelay) 1000
}

proc playback::playback {fn callback} {
    set fl [open $fn]
    fconfigure $fl -blocking 0
    playback::playback_helper $fl $callback
}

proc playback::pause {bool} {
    variable paused $bool
}

proc playback::stop {} {
    variable stop 1
}

proc playback::playback_helper {fl callback} {
    variable prefs
    variable paused
    variable stop
    if { $stop } return
    if { ! $paused } {
	if { ! [fblocked $fl] } {
	    gets $fl line
	    if { [eof $fl] } {
		return
	    }
	    uplevel [list $callback $line]
	}
    }
    after $prefs(playbackdelay) [list playback::playback_helper $fl $callback]
}
