# $Id: preferences.tcl,v 1.1.1.1 2003/09/09 23:36:29 davidw Exp $

package require Tk

if { [lsearch $auto_path .] < 0 } {
    lappend auto_path .
}

package require gridinfo

package provide preferences 0.1

namespace eval prefs {
    set id 0
    array set prefs {}
    set callback {}
}

proc prefs::addwidget {label code varname {default ""}} {
    variable id
    variable prefs
    variable p

    set pw $p.widgets

    set widget $pw.w$id
    label $pw.l$id -text $label -anchor w
    set code [linsert $code 1 $widget]
    switch -exact [lindex $code 0] {
	checkbutton {
	    lappend code -variable prefs::prefs($varname)
	}
	radiobutton {
	    lappend code -variable prefs::prefs($varname)
	}
	spinbox {
	    lappend code -textvariable prefs::prefs($varname)
	}
	entry {
	    lappend code -textvariable prefs::prefs($varname)
	}
    }
    namespace eval prefs $code
    grid $pw.l$id $widget -sticky wens
    grid columnconfigure $pw 0 -weight 1
    grid columnconfigure $pw 1 -weight 3

    grid rowconfigure $pw [gridinfo::row $pw.l$id] -weight 1

    incr id
}

proc prefs::create {userarr callbackproc} {
    variable p
    variable prefs
    variable callback $callbackproc

    upvar $userarr apparray

    catch { destroy .prefs }
    toplevel .prefs
    set p .prefs

    # Make local copy of main array.
    array set prefs {}
    foreach {key val} [array get apparray] {
	set prefs($key) $val
    }

    wm title $p "Preferences"

    label $p.title -text "Preferences"

    frame $p.widgets

    button $p.save -text "Save Changes"  -command prefs::save
    button $p.cancel -text "Close" -command prefs::cancel

    grid $p.title -columnspan 2 -sticky new
    grid $p.widgets -columnspan 2 -sticky news
    grid $p.save $p.cancel -sticky s
    grid configure $p.save -sticky w
    grid configure $p.cancel -sticky e

    grid columnconfigure $p 0 -weight 1
    grid rowconfigure $p 1 -weight 1
    raise $p
}

proc prefs::cancel {} {
    variable p
    destroy $p
}

proc prefs::save {} {
    variable prefs
    variable callback
    $callback prefs
}
