# $Id: tailf.tcl,v 1.1.1.1 2003/09/09 23:36:29 davidw Exp $

package provide tailf 0.1

namespace eval tailf {
    array set prefs {}
    set prefs(delay) 1000
    set paused 0
    set stop 0
}

proc tailf::tailf {filename callback} {
    variable mtime
    set fl [open $filename]
    seek $fl 0 end
    file stat $filename finfo
    set mtime $finfo(mtime)

    fconfigure $fl -blocking 0
    tailf_helper $filename $fl $callback
}

proc tailf::tailf_helper {filename fl callback} {
    variable prefs
    variable mtime
    variable paused
    variable stop

    if { $stop } return

    if { ! $paused } {
	file stat $filename finfo
	set newmtime $finfo(mtime)
	if { $newmtime > $mtime } {
	    while { ![fblocked $fl] } {
		gets $fl line
		if { [eof $fl] } { break }
		uplevel [list $callback $line]
	    }
	    set mtime $newmtime
	}
    }
    after $prefs(delay) [list tailf::tailf_helper $filename $fl $callback]
}

proc tailf::pause {bool} {
    variable paused $bool
}

proc tailf::stop {} {
    variable stop 1
}
