/* Words for eCos */

#include "ficl.h"
#include <cyg/kernel/kapi.h>

static void Key(FICL_VM *pVM)
{
    int retval = 0;
#if FICL_ROBUST > 1
    vmCheckStack(pVM, 0, 1);
#endif
    read(0, &retval, 1);
    stackPushINT(pVM->pStack, retval);
}

static void InB(FICL_VM *pVM)
{
    unsigned int retval = 0;
    unsigned int port = 0;

#if FICL_ROBUST > 1
    vmCheckStack(pVM, 1, 1);
#endif

    port = stackGetTop(pVM->pStack).u;
    HAL_READ_UINT8(port, retval);
    stackSetTop(pVM->pStack, LVALUEtoCELL(retval));
}

static void DoMSDelay(FICL_VM *pVM)
{
    unsigned int ms;
#if FICL_ROBUST > 1
    vmCheckStack(pVM, 1, 0);
#endif
    ms = stackPopUNS(pVM->pStack);
    cyg_thread_delay(ms);
}

static void OutB(FICL_VM *pVM)
{
    unsigned int port = 0;
    unsigned int val = 0;
#if FICL_ROBUST > 1
    vmCheckStack(pVM, 2, 0);
#endif

    port = stackPopUNS(pVM->pStack);
    val = stackPopUNS(pVM->pStack);
    HAL_WRITE_UINT8(port, val);
}

void ficlEcosWords(FICL_SYSTEM *pSys)
{
    FICL_DICT *dp = pSys->dp;
    assert (dp);

    dictAppendWord(dp, "inb",        InB,  FW_DEFAULT);
    dictAppendWord(dp, "key",        Key,  FW_DEFAULT);
    dictAppendWord(dp, "ms",         DoMSDelay,  FW_DEFAULT);
    dictAppendWord(dp, "outb",       OutB,  FW_DEFAULT);
}
