#! python
# Convert forth source files to a giant C string

import re;
import sys;
import time;


print """/*******************************************************************
** s o f t c o r e . c
** Forth Inspired Command Language - 
** Words from CORE set written in FICL
** Author: John Sadler (john_sadler@alum.mit.edu)
** Created: 27 December 1997
** Last update: """ + time.ctime(time.time()) + """
*******************************************************************/
/*
** DO NOT EDIT THIS FILE -- it is generated by softwords/softcore.pl
** Make changes to the .fr files in ficl/softwords instead.
** This file contains definitions that are compiled into the
** system dictionary by the first virtual machine to be created.
** Created automagically by ficl/softwords/softcore.pl 
*/
/*
** Copyright (c) 1997-2001 John Sadler (john_sadler@alum.mit.edu)
** All rights reserved.
**
** Get the latest Ficl release at http://ficl.sourceforge.net
**
** I am interested in hearing from anyone who uses ficl. If you have
** a problem, a success story, a defect, an enhancement request, or
** if you would like to contribute to the ficl release, please send
** contact me by email at the address above.
**
** L I C E N S E  and  D I S C L A I M E R
** 
** Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions
** are met:
** 1. Redistributions of source code must retain the above copyright
**    notice, this list of conditions and the following disclaimer.
** 2. Redistributions in binary form must reproduce the above copyright
**    notice, this list of conditions and the following disclaimer in the
**    documentation and/or other materials provided with the distribution.
**
** THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
** ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
** IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
** ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
** FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
** OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
** HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
** LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
** OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
** SUCH DAMAGE.
*/


#include "ficl.h"

static char softWords[] = 
#if FICL_WANT_SOFTWORDS"""

escapedQuotes = re.compile( r'^"(.*)"$' )
backslash = re.compile( r'^(.*[^\s])\s+\\(\s+[^\s].*)$' )
parentheses = re.compile( r'^(.*[^\s])\s+\(\s[^)]+\)(\s+[^\s].*)?$' )


commenting = 0;

for a in (sys.argv[1:]):
	f = open(a)
	for line in f.readlines():

		# trim all whitespace
		line = line.strip();

		# remove quotes around quoted lines
		quoted = escapedQuotes.match(line)
		if (quoted != None):
			line = quoted.group(1).strip()

		#
		# emit lines beginnning with "\ **" as C comments
		#
		if (line[0:4] == "\\ **"):
			if (commenting == 0):
				print("/*")
			commenting = 1
			print(line[2:])
			continue

		if (commenting == 1):
			print "*/"

		commenting = 0

		# ignore empty lines
		if (len(line) == 0):
			continue

		# pass commented preprocessor directives
		# == lines starting with "\ #"
		# (supports single line directives only)
		if (line[0:3] == "\\ #"):
			print(line[2:]) # include the leading #!
			continue

		# ignore remaining lines starting with comments
		if (line[0] == "\\"):
			continue

		# remove trailing comments
		trailingComment = backslash.match(line)
		if (trailingComment != None):
			line = trailingComment.group(1)

		# remove ( comments ) in the middle
		embeddedComment = parentheses.match(line)
		if (embeddedComment != None):
			line = embeddedComment.group(1)
			if (embeddedComment.lastindex >= 2):
				line = line + " " + embeddedComment.group(2).strip()

		# quote double-quote characters
		line = line.replace("\"", "\\\"")

		# emit whatever's left as quoted string fragments
		print("    \"" + line + " \"");


print """#endif /* WANT_SOFTWORDS */
    "quit ";


void ficlCompileSoftCore(FICL_SYSTEM *pSys)
{
    FICL_VM *pVM = pSys->vmList;
    CELL id = pVM->sourceID;
    int ret = sizeof (softWords);
    assert(pVM);
    pVM->sourceID.i = -1;
    ret = ficlExec(pVM, softWords);
    pVM->sourceID = id;
    if (ret == VM_ERREXIT)
        assert(FALSE);
    return;
}


"""
